<?php
$bot_token = "8269282132:AAG_KsbOR5hmX8tudjJtPkocn4RBf-eoxu8"; // Ganti token bot kamu
$file_json = __DIR__ . "/data.json";
$upload_dir = __DIR__ . "/uploads";

// === Buat folder uploads jika belum ada ===
if (!is_dir($upload_dir)) mkdir($upload_dir, 0777, true);

// === Baca data dari Telegram ===
$content = file_get_contents("php://input");
$update = json_decode($content, true);

if (!$update) {
    http_response_code(400);
    exit("No update data received");
}

// === Pastikan file JSON valid ===
if (!file_exists($file_json)) file_put_contents($file_json, "[]");
$data = json_decode(file_get_contents($file_json), true);
if (!is_array($data)) $data = [];

// === Ambil pesan (channel_post / message / edited_channel_post) ===
$msg = $update["channel_post"] ?? $update["message"] ?? $update["edited_channel_post"] ?? null;
if (!$msg) exit("No message");

// === Jika reply dengan kata 'hapus' ===
if (isset($msg["reply_to_message"]) && isset($msg["text"])) {
    $text = strtolower(trim($msg["text"]));
    if ($text === "hapus") {
        $target_id = $msg["reply_to_message"]["message_id"];

        // Hapus dari JSON
        $new_data = array_filter($data, fn($d) => $d["message_id"] != $target_id);
        file_put_contents($file_json, json_encode(array_values($new_data), JSON_PRETTY_PRINT | JSON_UNESCAPED_SLASHES));

        // Kirim konfirmasi ke channel
        $chat_id = $msg["chat"]["id"];
        $confirm_url = "https://api.telegram.org/bot{$bot_token}/sendMessage";
        $payload = [
            'chat_id' => $chat_id,
            'text' => "✅ Sukses Menghapus, Silahkan Hapus Via Channel {$target_id} t",
            'reply_to_message_id' => $msg["message_id"]
        ];
        file_get_contents($confirm_url . "?" . http_build_query($payload));

        exit("Deleted");
    }
}

// === Format data baru ===
$entry = [
    "message_id" => $msg["message_id"],
    "judul" => "Informasi",
    "deskripsi" => "",
    "isi" => "",
    "media" => "",
    "url" => "",
    "tanggal" => date("c")
];

// === Ambil teks / caption ===
$text = $msg["text"] ?? $msg["caption"] ?? "";
$entry["deskripsi"] = trim($text);

// Deteksi URL dalam teks
if (preg_match('/https?:\/\/[^\s]+/', $text, $match)) {
    $entry["url"] = $match[0];
}

// === Jika ada foto ===
if (isset($msg["photo"])) {
    $photo_array = $msg["photo"];
    $file_id = end($photo_array)["file_id"];

    // Ambil file path dari Telegram
    $get_file = "https://api.telegram.org/bot{$bot_token}/getFile?file_id={$file_id}";
    $file_info = json_decode(file_get_contents($get_file), true);

    if (isset($file_info["result"]["file_path"])) {
        $file_path = $file_info["result"]["file_path"];
        $file_url = "https://api.telegram.org/file/bot{$bot_token}/{$file_path}";

        // Simpan ke server lokal
        $file_name = basename($file_path);
        $local_path = $upload_dir . "/" . $file_name;

        // Unduh gambar
        $image_data = file_get_contents($file_url);
        if ($image_data !== false) {
            file_put_contents($local_path, $image_data);

            // Ubah media ke URL lokal
            $domain = (isset($_SERVER['HTTPS']) ? "https" : "http") . "://" . $_SERVER['HTTP_HOST'];
            $entry["media"] = $domain . "/informasi/uploads/" . $file_name;
        }
    }
}

// === Simpan data baru ke JSON ===
$data[] = $entry;
file_put_contents($file_json, json_encode($data, JSON_PRETTY_PRINT | JSON_UNESCAPED_SLASHES));

echo "OK";
?>
